//
//  MCCalendarDatePicker.h
//  MCApplication
//
//  Created by Michael Clark on 21/02/06.
//  Copyright 2006 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#import "MCWindowController.h"


typedef enum _MCCalendarDatePickerMode {
    MCCalendarDatePickerPopUpMode        = 1,
    MCCalendarDatePickerDialogMode,
    MCCalendarDatePickerSheetMode
} MCCalendarDatePickerMode;


@class MCCalendarDatePickerContainerView, MCCalendarDatePickerView;

@interface MCCalendarDatePicker : MCWindowController {
	IBOutlet MCCalendarDatePickerContainerView*    containerView;
	IBOutlet MCCalendarDatePickerView*             datePickerView;
	
	MCCalendarDatePickerMode        __runMode;
	
	id                              __delegate; // weak ref
	id                              __representedObject;
    
	BOOL  __weClosedWindow;
}


+ (void)popUpDatePickerForView: (NSView*)view selectedDate: (NSCalendarDate*)aDate 
                      delegate: (id)delegate representedObject:(id)aRepresentedObject frame:(NSRect)aFrame;
+ (void)popUpDatePickerForView: (NSView*)view selectedDate: (NSCalendarDate*)aDate delegate: (id)delegate;


// Do not invoke!
- (void)endEditing;
- (void)endEditingWithNoSelection; // Will not select a date




#pragma mark Accessors
- (MCCalendarDatePickerMode)runMode;
- (void)setRunMode:(MCCalendarDatePickerMode)aRunMode;

// These are wrappers around the datePickerView
- (NSCalendarDate*)selectedDate;
- (void)setSelectedDate: (NSCalendarDate*)aDate;

- (id)delegate;
- (void)setDelegate:(id)aDelegate;

- (id)representedObject;
- (void)setRepresentedObject:(id)aRepresentedObject;
@end


@interface NSObject (MCCalendarDatePickerDelegate)

- (void)calendarDatePicker: (MCCalendarDatePicker*)aPicker selectedDate: (NSCalendarDate*)aDate;
- (void)calendarDatePicker: (MCCalendarDatePicker*)aPicker endEditingWithDate: (NSCalendarDate*)aDate;

@end
